// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "creditsession.h"

namespace Application
{
	namespace Sessions
	{
		CreditSession::CreditSession():
		_firstScreen( false ), _backgroundActor ( new ImageActor( ScreenDataFile::getInstance()->getScreen( CreditsScreen ) ) )
		{
			LoadIntroSound();
		}

		void CreditSession::Destruct()
		{
			delete _backgroundActor;
		}

		void CreditSession::HandleUserInput()
		{
			if ( keypressed() )
			{
				Session::SetupMouse();
				SessionManager::getInstance()->setNextSession( new MainMenuSession() );
			}
		}

		void CreditSession::LoadIntroSound()
		{
			play_midi( SoundDataFile::getInstance()->getMidiSound( (soundTrack)Random::GetNumber( 3, 7 ) ), false );
		}

		void CreditSession::PopulateRenderingBuffer()
		{
			if ( !_firstScreen )
			{
				_backgroundActor->Render( screen );
				_firstScreen = true;
			}
		}
	}
}
