// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "bulletsdatafile.h"

namespace GameContent
{
	BulletsDataFile* BulletsDataFile::_bulletsDataFile = NULL;
	
	BulletsDataFile::BulletsDataFile()
	{
		setFileName( BOMBS_FILE_NAME );
	}

	BITMAP* BulletsDataFile::getPlayerBulletFrame() const
	{
		return getBitmap(3);
	}

	BITMAP* BulletsDataFile::getAlienBulletFrame( int Frame ) const
	{
		return getBitmap( Frame );
	}

	BulletsDataFile* BulletsDataFile::getInstance()
	{
		return ( _bulletsDataFile == NULL ) ? _bulletsDataFile = new BulletsDataFile() : _bulletsDataFile;
	}
}