// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "bonusshipmanager.h"
#include "gamesession.h"
using namespace Application::Sessions;

namespace GameEngine
{
	namespace Managers
	{
		BonusShipManager::BonusShipManager( unsigned short int BonusShips ):
		_bonusShips( BonusShips )
		{
		}
		
		void BonusShipManager::HandleMovement()
		{
			BonusShip* bonusShip = ((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getBonusShip();
			ShouldBonusShipLaunch();
			if ( bonusShip->getBonusType() != NotDefinedBonus )
				bonusShip->Move();
		}

		void BonusShipManager::ShouldBonusShipLaunch()
		{
			BonusShip* bonusShip = ((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getBonusShip();
			if ( bonusShip->getBonusType() == NotDefinedBonus && _bonusShips > 0 )
			{
				if ( Random::GetNumber(0,10) == _bonusShips )
				{
					bonusShip->setBonusType( (BonusTypes)Random::GetNumber(1,4) );
					_bonusShips--;
				}
			}
		}

		bool BonusShipManager::CheckForCollision( PlayerBullet* PlayerBullet )
		{
			BonusShip* bonusShip = ((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getBonusShip();
			if ( bonusShip->getBonusType() != NotDefinedBonus )
			{
				if ( bonusShip->getRectangle()->IntersectsWith( PlayerBullet->getRectangle() ) )
				{
					bonusShip->setActorState( Exploding );
					return true;
				}
			}

			return false;
		}
	}
}