// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "aliendatafile.h"
#include "AnimationFacade.h"
#include "bonusdatafile.h"
#include "statesfacade.h"
using namespace GameContent;

#define BONUS_SHIP_VERTICAL_SPACE 50

namespace GameEngine
{
	namespace Actors
	{
		class BonusShip : public Actor, public AnimationFacade, public StatesFacade<ActorStates>
		{
			private:
				BonusTypes _bonusType;
				void setCurrentFrame();
				void stateChanged();
			public:
				BonusShip();
				void Move();
				BonusTypes getBonusType() const;
				void setBonusType( BonusTypes );
				BITMAP* getBitmap() const;
		};
	}
}