// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "bonusdatafile.h"

namespace GameContent
{
	BonusDataFile* BonusDataFile::_bonusDataFile = NULL;
	
	BonusDataFile::BonusDataFile()
	{
		setFileName(BONUS_FILE_NAME);
	}

	BonusDataFile* BonusDataFile::getInstance()
	{
		return ( _bonusDataFile == NULL ) ? _bonusDataFile = new BonusDataFile() : _bonusDataFile;
	}

	BITMAP* BonusDataFile::getBonusFrame( BonusTypes bonusType, int Frame ) const
	{
		switch( bonusType )
		{
			case Planet:
				return getBitmap( Frame );
			case PlainSaucer:
				return getBitmap( Frame + 2 );
			case HatSaucer:
				return getBitmap( Frame + 4 );
			case FancySaucer:
				return getBitmap( Frame + 6 );
		}

		return NULL;
	}
}