// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "Allegro_Engine.h"

namespace AllegroEngine
{
	Allegro_Engine::Allegro_Engine( AllegroSettings* settings )
	{
		setSettings( settings );
	}

	Allegro_Engine::~Allegro_Engine()
	{
		if ( _settings != NULL )
			delete _settings;
		allegro_exit();
	}

	void Allegro_Engine::handleSettings()
	{
		if ( _settings != NULL )
		{
			allegro_init();	
			if ( _settings->getUseKeyboard() )
				install_keyboard();

			if ( _settings->getUseMouse() )
				install_mouse();
			
			set_color_depth( _settings->getColorDepth() );
						
			if ( set_gfx_mode( GFX_AUTODETECT, _settings->getWidth(), _settings->getHeight(), _settings->getVirtualWidth(), _settings->getVirtualHeight() ) != 0 )
				allegro_message( GRAPHICS_FAILED );

			if ( install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,NULL) != 0 )
				allegro_message( SOUND_FAILED );
		}
		else
			allegro_message( SETTINGS_NOT_FOUND );
	}

	void Allegro_Engine::setSettings( AllegroSettings* Settings )
	{
		_settings=Settings;
		handleSettings();
	}
}