// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "alien.h"
#include "gamesession.h"
using namespace Application::Sessions;

namespace GameEngine
{
	namespace Actors
	{
		Alien::Alien( AlienTypes AlienType ):
		_alienType( AlienType )
		{
			setActorState( Alive );
		}

		AlienTypes Alien::getAlienType() const
		{
			return _alienType;
		}

		void Alien::Move( MoveDirection Direction )
		{
			if ( _actorState == Alive )
			{
				int speed = ((GameSession*)SessionManager::getInstance()->getCurrentSession())->getLevel()->getAlienSpeed();
				switch (Direction)
				{
					case MoveLeft:
					{
						_location->x -= speed;
						break;
					}
					case MoveRight:
					{
						_location->x += speed;
						break;
					}
					case MoveDown:
					{
						_location->y += speed;
						break;
					}
				}
			}

			setCurrentFrame();
		}

		void Alien::stateChanged()
		{
			switch( _actorState )
			{
				case Alive:
				{
					_delay = GameSettings::getInstance()->getAlienAnimationDelay();
					break;
				}
				case Exploding:
				{
					_delay = GameSettings::getInstance()->getAlienExplosionDelay();
					break;
				}
				default:
				{
					_delay = 0;
					break;
				}
			}

			_currentFrame = 0;
		}

		void Alien::setCurrentFrame()
		{
			--_delay;
			switch( _actorState )
			{
				case Alive:
				{
					if ( _delay == 0 )
					{
						_currentFrame = ( _currentFrame == 0 ) ? 1 : 0;
						_delay = GameSettings::getInstance()->getAlienAnimationDelay();
					}
					break;
				}
				case Exploding:
				{
					if ( _delay == 0 )
					{
						((GameSession*)SessionManager::getInstance()->getCurrentSession())->getPlayerPanel()->getScoreBoard()->changeScore( AlienHit );
						RemoveFromContainer();
					}
					break;
				}
			}
		}

		Point* Alien::getBulletStartLocation()
		{
			return new Point( _location->x - 4 + getWidth()/2, _location->y );
		}

		BITMAP* Alien::getBitmap() const
		{
			switch ( _actorState )
			{
				case Alive:
					return AlienDataFile::getInstance()->getAlienFrame( _alienType, _currentFrame );
				case Exploding:
					return AlienDataFile::getInstance()->getExplosionFrame( _currentFrame );
			}

			return NULL;
		}
	}
}