// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "actor.h"

namespace GameEngine
{
	namespace Actors
	{
		Actor::Actor():
		_location( NULL ), _rectangle( NULL )
		{
		}

		Actor::~Actor()
		{
			if ( _location != NULL )
			{
				delete _location;
				_location = NULL;
			}

			if ( _rectangle != NULL )
			{
				delete _rectangle;
				_rectangle = NULL;
			}
		}
		
		void Actor::setLocation( Point* Location )
		{
			_location = Location;
		}

		Point* Actor::getLocation() const
		{
			return _location;
		}

		Rectangle* Actor::getRectangle() 
		{
			return ( _location != NULL ) ? ( _rectangle == NULL ) ? _rectangle = new Rectangle( _location, getHeight(), getWidth() ) : _rectangle : NULL;
		}

		void Actor::DrawSprite( BITMAP* Buffer, BITMAP* obj )
		{
			if ( _location != NULL && obj != NULL ) draw_sprite( Buffer, obj, _location->x, _location->y );
		}

		void Actor::Blit( BITMAP* Buffer, BITMAP* obj )
		{
			if ( _location != NULL && obj != NULL ) blit( obj, Buffer, 0,0, _location->x, _location->y, obj->w, obj->h );
		}

		int Actor::getHeight() const
		{
			return ( getBitmap() != NULL ) ? getBitmap()->h : 0;
		}

		int Actor::getWidth() const
		{
			return ( getBitmap() != NULL ) ? getBitmap()->w : 0;
		}

		void Actor::Render( BITMAP* buffer )
		{
			DrawSprite( buffer, getBitmap() );
		}
		
		void Actor::Move()
		{
		}
	}
}