// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "datafile.h"

namespace GameContent
{
	enum soundTrack { becomeBig, bonus, explodePlayer, load0, load1, load2, load3, load4, lost, shoot, start, won };

	class SoundDataFile : public DataFile
	{
		private:
			static SoundDataFile* _soundDataFile;
		public:
			SoundDataFile();
			static SoundDataFile* getInstance();
			MIDI* getMidiSound( soundTrack ) const;
			SAMPLE* getSampleSound( soundTrack ) const;
	};
}