// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "sounddatafile.h"

namespace GameContent
{
	SoundDataFile* SoundDataFile::_soundDataFile = NULL;
	
	SoundDataFile::SoundDataFile()
	{
		setFileName(SOUND_FILE_NAME);
	}

	SoundDataFile* SoundDataFile::getInstance()
	{
		return ( _soundDataFile == NULL ) ? _soundDataFile = new SoundDataFile() : _soundDataFile;
	}

	MIDI* SoundDataFile::getMidiSound( soundTrack track ) const
	{
		switch ( track )
		{
			case becomeBig:
				return getMidi( 0 );
			case load0:
				return getMidi( 3 );
			case load1:
				return getMidi( 4 );
			case load2:
				return getMidi( 5 );
			case load3:
				return getMidi( 6 );
			case load4:
				return getMidi( 7 );
			case lost:
				return getMidi( 8 );
			case won:
				return getMidi( 11 );
		}	

		return NULL;
	}

	SAMPLE* SoundDataFile::getSampleSound( soundTrack track ) const
	{
		switch ( track )
		{
			case bonus:
				return getSample( 1 );
			case explodePlayer:
				return getSample( 2 );
			case shoot:
				return getSample( 9 );
			case start:
				return getSample( 10 );
		}	

		return NULL;
	}
}