// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "sessionmanager.h"
#include "gametimer.h"
using namespace GameTimer;

namespace GameTimer
{
	void target_incrementor()
	{
		_targetCycle++;
	}

	END_OF_FUNCTION(target_incrementor);

	void initTimer()
	{
		srand(clock());
		_targetCycle = 0;
		LOCK_VARIABLE(_targetCycle);
		LOCK_FUNCTION(target_incrementor);
		install_int_ex(target_incrementor, BPS_TO_TIMER(30));
	}

	void removeTimer()
	{
		remove_int(target_incrementor);
	}
}

namespace Application
{
	SessionManager* SessionManager::_sessionManager = 0;

	SessionManager* SessionManager::getInstance()
	{
		return ( _sessionManager == 0 ) ? _sessionManager = new SessionManager() : _sessionManager;
	}

	Session* SessionManager::getCurrentSession()
	{
		return _currentSession;
	}

	void SessionManager::setNextSession( Session* Session )
	{
		_sessionState = Switching;
		_nextSession = Session;
	}

	SessionManager::SessionManager():
	_actualCycle(0), _currentSession(NULL), _nextSession(NULL), _sessionState( NotDefined )
	{
		initTimer();
	}

	void SessionManager::Start()
	{
		_sessionState = Running;
		_currentSession = new CreditSession();
		HandleSessionState();
	}

	SessionManager::~SessionManager()
	{
		removeTimer();

		delete AlienDataFile::getInstance();
		delete SoundDataFile::getInstance();
		delete BulletsDataFile::getInstance();
		delete PlayerDataFile::getInstance();
		delete BonusDataFile::getInstance();
		delete ScreenDataFile::getInstance();
		delete LevelLoader::getInstance();
		delete RenderingEngine::getInstance();
		delete HighscoreManager::getInstance();
	}

	void SessionManager::HandleSessionState()
	{
		switch( _sessionState )
		{
			case Running:
			{
				while( _sessionState == Running )
				{
					HandleUserInput();
					Render();
					while (_targetCycle > _actualCycle && _sessionState == Running)
						HandleMovement();
				}
				break;
			}
			case Switching:
			{
				StopCurrentSession();
				SwitchSessions();
				_sessionState = Running;
				break;
			}
			case Ending:
			{
				StopCurrentSession();
				break;
			}
		}

		if ( _sessionState != Ending )
			HandleSessionState();
	}

	void SessionManager::HandleUserInput()
	{
		_currentSession->HandleUserInput();
	}

	void SessionManager::StopCurrentSession()
	{
		remove_keyboard();
		_currentSession->Destruct();
		delete _currentSession;
	}

	void SessionManager::SwitchSessions()
	{
		install_keyboard();
		_currentSession = _nextSession;
		_nextSession = NULL;
	}

	void SessionManager::Render()
	{
		RenderingEngine::getInstance()->ClearBuffer();
		_currentSession->PopulateRenderingBuffer();
		RenderingEngine::getInstance()->Render();
	}

	void SessionManager::HandleMovement()
	{
		_currentSession->HandleMovement();
		_actualCycle++;
	}

	void SessionManager::Stop()
	{
		_sessionState = Ending;
	}

	void SessionManager::Pause()
	{
		StopTimer();
		ResetKeyboard();
		readkey();
		StartTimer();
	}

	void SessionManager::StopTimer()
	{
		_actualCycle = 0;
		removeTimer();
	}

	void SessionManager::StartTimer()
	{
		initTimer();
	}

	void SessionManager::ResetKeyboard()
	{
		remove_keyboard();
		install_keyboard();
	}

	int SessionManager::getTargetCycle()
	{
		return _targetCycle;
	}

	void SessionManager::DrawAnnouncement( BITMAP* Announcement )
	{
		draw_sprite( screen, Announcement, (SCREEN_W - Announcement->w)/2, (SCREEN_H - Announcement->h)/2 );
	}
}