// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "screendatafile.h"

namespace GameContent
{
	ScreenDataFile* ScreenDataFile::_screenDataFile = NULL;
	
	ScreenDataFile::ScreenDataFile()
	{
		setFileName( SCREEN_FILE_NAME );
	}

	ScreenDataFile* ScreenDataFile::getInstance()
	{
		return ( _screenDataFile == NULL ) ? _screenDataFile = new ScreenDataFile() : _screenDataFile;
	}

	BITMAP* ScreenDataFile::getScreen( ScreenTypes screenType ) const
	{
		switch( screenType )
		{
			case EnterName:
				return getBitmap( 0 );
			case GameOver:
				return getBitmap( 1 );
			case HighScoreScreen:
				return getBitmap( 2 );
			case CreditsScreen:
				return getBitmap( 3 );
			case Letters:
				return getBitmap( 4 );
			case LevelScreen:
				return getBitmap( 5 );
			case LevelNum1:
				return getBitmap( 6 );
			case LevelNum2:
				return getBitmap( 7 );
			case LevelNum3:
				return getBitmap( 8 );
			case LevelNum4:
				return getBitmap( 9 );
			case LevelNum5:
				return getBitmap( 10 );
			case LevelNum6:
				return getBitmap( 11 );
			case MainMenuScreen:
				return getBitmap( 12 );
			case Num0:
				return getBitmap( 13 );
			case Num1:
				return getBitmap( 14 );
			case Num2:
				return getBitmap( 15 );
			case Num3:
				return getBitmap( 16 );
			case Num4:
				return getBitmap( 17 );
			case Num5:
				return getBitmap( 18 );
			case Num6:
				return getBitmap( 19 );
			case Num7:
				return getBitmap( 20 );
			case Num8:
				return getBitmap( 21 );
			case Num9:
				return getBitmap( 22 );
			case OptionsScreen:
				return getBitmap( 23 );
			case PlayerLives:
				return getBitmap( 24 );
			case PressAny:
				return getBitmap( 25 );
			case Sure:
				return getBitmap( 26 );
		}
		return NULL;
	}
}