// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "renderingengine.h"
#include "framestimer.h"
using namespace FramesTimer;

namespace FramesTimer
{
	void count_frames()
	{
		_fps = _fpsCounter;
		_fpsCounter = 0;
	}

	END_OF_FUNCTION(count_frames);
	
	void initFramesTimer()
	{
		install_timer();
		LOCK_VARIABLE(_fps);
		LOCK_VARIABLE(_fpsCounter);
		LOCK_FUNCTION(count_frames);
		install_int_ex(count_frames, BPS_TO_TIMER(1));
	}

	void removeFramesTimer()
	{
		remove_int(count_frames);
	}
}

namespace Renderer
{
	RenderingEngine* RenderingEngine::_renderingEngine = NULL;
	
	RenderingEngine::RenderingEngine():
	_buffer( create_bitmap( SCREEN_W, SCREEN_H ) ), _waitForVsync( false ), _bufferIsDirty( false )
	{
		initFramesTimer();
	}

	RenderingEngine::~RenderingEngine()
	{
		removeFramesTimer();
		destroy_bitmap(_buffer);
	}

	void RenderingEngine::Render()
	{
		if ( _bufferIsDirty )
		{
			acquire_screen();
			if ( _waitForVsync ) vsync();
			textprintf(_buffer, font, 0, 32, makecol(255, 255, 255), "FPS: %d", _fps);
			blit( _buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H );
			_fpsCounter++;
			release_screen();
			_bufferIsDirty = false;
		}
	}
	
	RenderingEngine* RenderingEngine::getInstance()
	{
		return ( _renderingEngine == NULL ) ? _renderingEngine = new RenderingEngine() : _renderingEngine;
	}

	BITMAP* RenderingEngine::getBuffer()
	{
		_bufferIsDirty = true;
		return _buffer;
	}

	void RenderingEngine::ClearBuffer()
	{
		clear_bitmap(_buffer);
	}
}