// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "PlayerDataFile.h"
#include <allegro.h>

namespace GameContent
{
	PlayerDataFile* PlayerDataFile::_playerDataFile = NULL;
	
	PlayerDataFile::PlayerDataFile()
	{
		setFileName(PLAYER_FILE_NAME);
	}

	BITMAP* PlayerDataFile::getExplosionFrame( int Frame ) const
	{
		return getBitmap( Frame );
	}

	BITMAP* PlayerDataFile::getPlayer( PlayerTypes playerType ) const
	{
		switch( playerType )
		{
			case SmallPlayer:
				return (BITMAP*)_dataFile[37].dat;
			case BigPlayer:
				return (BITMAP*)_dataFile[36].dat;
		}

		return NULL;
	}

	PlayerDataFile* PlayerDataFile::getInstance()
	{
		return ( _playerDataFile == NULL ) ? _playerDataFile = new PlayerDataFile() : _playerDataFile;
	}
}
