// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "player.h"
#include "gamesession.h"
using namespace Application::Sessions;

namespace GameEngine
{
	namespace Actors
	{
		Player::Player( PlayerTypes PlayerTypes ):
		_playerType( PlayerTypes )
		{
			setActorState( PlayerAlive );
			_location = new Point( SCREEN_W / 2 - 35, SCREEN_H - 50 );
		}

		void Player::Move( MoveDirection PlayerDirection )
		{
			int speed = ((GameSession*)SessionManager::getInstance()->getCurrentSession())->getLevel()->getPlayerSpeed();

			switch( PlayerDirection )
			{
				case MoveLeft:
				{
					_location->x -= speed;
					if ( _location->x < 5 )
						_location->x = 5;

					break;
				}
				case MoveRight:
				{
					if ( _location->x > SCREEN_W - PlayerDataFile::getInstance()->getPlayer( _playerType )->w - 15  )
						_location->x = SCREEN_W - PlayerDataFile::getInstance()->getPlayer( _playerType )->w - 15;

					_location->x += speed;
					break;
				}
			}
		}

		Point* Player::getBulletStartLocation()
		{
			return new Point( _location->x - 4 + getWidth()/2, _location->y );
		}

		bool Player::CheckForCollision( AlienBullet* AlienBullet )
		{
			if ( _actorState == PlayerAlive )
			{
				if ( getRectangle()->IntersectsWith( AlienBullet->getRectangle() ) )
				{
					setActorState( PlayerExploding );
					AlienBullet->RemoveFromContainer();
					return true;
				}
			}

			return false;
		}

		void Player::Move()
		{
			setCurrentFrame();
		}

		void Player::stateChanged()
		{
			switch ( _actorState )
			{
				case PlayerExploding:
				{
					play_midi( NULL, false );
					play_sample( SoundDataFile::getInstance()->getSampleSound( explodePlayer ), 200, 125, 1000, 0 );
 	 				_delay = GameSettings::getInstance()->getPlayerExplosionAnimationDelay();
					break;
				}
			}

			_currentFrame = 0;
		}

		void Player::setCurrentFrame()
		{
			switch ( _actorState )
			{
				case PlayerExploding:
				{
					--_delay;
					if ( _delay == 0 )
					{
						_currentFrame++;
						if ( _currentFrame == 35 )
							_actorState = PlayerDead;
						else
							_delay = GameSettings::getInstance()->getPlayerExplosionAnimationDelay();
					}
					break;
				}
			}
		}

		BITMAP* Player::getBitmap() const
		{
			switch ( _actorState )
			{
				case PlayerAlive:
					return PlayerDataFile::getInstance()->getPlayer( _playerType );
				case PlayerExploding:
					return PlayerDataFile::getInstance()->getExplosionFrame( _currentFrame );
			}
			
			return NULL;
		}
	}
}