// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "InputSession.h"

namespace Application
{
	namespace Sessions
	{
		InputSession::InputSession():
		_okArea( new Rectangle( new Point( OK_AREA_X, OK_AREA_Y ), OK_AREA_H, OK_AREA_W ) ),
		_backgroundActor( new ImageActor( ScreenDataFile::getInstance()->getScreen( EnterName ) ) ), _firstScreen( false ),
		inputBuffer( create_bitmap(BUFFER_W, BUFFER_H) ), caret( 0 ), insert( true )
		{
			_midiPlayer = true;
			iter = edittext.begin();
		}

		void InputSession::Destruct()
		{
			delete _okArea;
			destroy_bitmap(inputBuffer);
		}

		void InputSession::HandleUserInput()
		{
			//////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//////////////////////////////////////////////////////////////////////////////////////////////////////////////
			while( keypressed() ) 
			{ 
				int newkey = readkey(); 
				char ASCII = newkey & 0xff; 
				char scancode = newkey >> 8; 
				// a character key was pressed; add it to the string 
				if(ASCII >= 32 && ASCII <= 126) 
				{ 
					// add the new char, inserting or replacing as need be 
					if(insert || iter == edittext.end()) 
						iter = edittext.insert(iter, ASCII); 
					else 
						edittext.replace(caret, 1, 1, ASCII); 
				
					// increment both the caret and the iterator 
					caret++; iter++; 
				} 
			
				// some other, "special" key was pressed; handle it here else 
				switch(scancode) 
				{ 
				case KEY_DEL: 
					if(iter != edittext.end()) 
						iter = edittext.erase(iter); 
					break; 
				case KEY_BACKSPACE:
					_firstScreen = false;
					if(iter != edittext.begin()) 
					{ 
						caret--; iter--; 
						iter = edittext.erase(iter); 
					} 
					break;
				case KEY_RIGHT: 
					if(iter != edittext.end()) 
					{
						caret++, iter++; 
					}
					break; 
				case KEY_LEFT: 
					if(iter != edittext.begin())
					{
						caret--, iter--; 
					}
					break; 
				case KEY_INSERT: 
					insert = !insert; 
					break; 
				default: 
					break; 
				} 
			} 
			// clear screen 
			clear_to_color(inputBuffer, makecol(255,0,255)); // output the string to the screen
			text_mode(-1);
			textout(inputBuffer, font, edittext.c_str(), 10, 10, makecol(0, 0, 0)); 
			// draw the caret 
			vline(inputBuffer, caret * 8, 8, 18, makecol(255, 0, 255)); 
			
			// blit to screen 
			masked_blit(inputBuffer, screen, 0, 0, 328, 271, BUFFER_W, BUFFER_H); 
			//////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//////////////////////////////////////////////////////////////////////////////////////////////////////////////
			Point* mousePoint = new Point( mouse_x, mouse_y );

			if ( (mouse_b & 1 && _okArea->Contains( mousePoint ) ) )
				SessionManager::getInstance()->setNextSession( new MainMenuSession() );

			delete mousePoint;
		}

		void InputSession::PopulateRenderingBuffer()
		{
			if ( !_firstScreen )
			{
				scare_mouse();
				_backgroundActor->Render( screen );

				unsigned int toShow = ScoreBoard::getInstance()->getCurrentScore();
				int index  = 0;
				int x = 350;

				if ( toShow == 0 )
					masked_blit( ScreenDataFile::getInstance()->getScreen( Num0 ), screen, 0, 0, x, 220, NUM_W, NUM_H );
				else
				{
					while( toShow > 0 )
					{
						index = toShow % 10 ;
						toShow = toShow / 10;
						masked_blit( ScreenDataFile::getInstance()->getScreen( (ScreenTypes)(index + NUMBERS_LOCATION) ), screen, 0, 0, x, 220, NUM_W, NUM_H ); 
						x = x - NEXT_NUMBER;
					}
				}

				unscare_mouse();
				show_mouse(screen);
				_firstScreen = true;
			}
		}

		Scene* InputSession::getScene()
		{
			return NULL;
		}
	}
}