// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "GameSettings.h"

namespace GameEngine
{
	GameSettings* GameSettings::_gameSettings = 0;

	GameSettings* GameSettings::getInstance()
	{
		return ( _gameSettings == 0 ) ? _gameSettings = new GameSettings() : _gameSettings;
	}

	GameSettings::GameSettings():
	_alienExplosionDelay(1), _playerExplosionAnimationDelay(2),_alienBulletAnimationDelay(2),
	_bulletChancePerSecond(0.02f), _playerLives(1),
	_alienAnimationDelay(20), _bonusShipAnimationDelay(10),
	_bonusPoints(100), _alienPoints(50), _singleFire ( true )
	{
	}

	GameSettings::~GameSettings()
	{
	}

	int GameSettings::getAlienAnimationDelay() const
	{
		return _alienAnimationDelay;
	}

	int GameSettings::getBonusShipAnimationDelay() const
	{
		return _bonusShipAnimationDelay;
	}

	int GameSettings::getPlayerLives() const
	{
		return _playerLives;
	}

	float GameSettings::getBulletChancePerSecond() const
	{
		return _bulletChancePerSecond;
	}

	int GameSettings::getAlienBulletAnimationDelay() const
	{
		return _alienBulletAnimationDelay;
	}

	int GameSettings::getPlayerExplosionAnimationDelay() const
	{
		return _playerExplosionAnimationDelay;
	}

	int GameSettings::getAlienExplosionDelay() const
	{
		return _alienExplosionDelay;
	}

	int GameSettings::getBonusPoints() const
	{
		return _bonusPoints;
	}

	int GameSettings::getAlienPoints() const
	{
		return _alienPoints;
	}

	bool GameSettings::getSingleFire() const
	{
		return _singleFire;
	}

	void GameSettings::setAlienPoints( int points )
	{
		_alienPoints = points;
	}

	void GameSettings::setBonusPoints( int points )
	{
		_bonusPoints = points;
	}

	void GameSettings::setBulletChancePerSecond( float chance )
	{
		_bulletChancePerSecond = chance;
	}

	void GameSettings::setPlayerLives( int lives )
	{
		_playerLives = lives;
	}

	void GameSettings::setSingleFire( bool single )
	{
		_singleFire = single;
	}
}