// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "scene.h"
#include "Alien.h"
using namespace GameEngine::Actors;
#include "imageactor.h"
#include "alienbullet.h"
#include "playerbullet.h"
#include "player.h"
#include "platformpart.h"
#include "itemlist.cpp"
#include "bonusship.h"
using namespace DataStructures;
using namespace GameEngine;

#define PLATFORMS_NUM 4

namespace Application
{
	namespace Scenery
	{
		class GameScene : public Scene
		{
			private:
				ItemList<Alien*>* _aliens;
				ItemList<PlayerBullet*>* _playerBullets;
				ItemList<AlienBullet*>* _alienBullets;
				ItemList<PlatformPart*>* _platformParts;
				ImageActor* _backgroundActor;
				Player* _player;
				BonusShip* _bonusShip;
				void PopulateAlienList( AlienTypes );
				void PopulatePlatformList();
				void setBackgroundActor();
				void PopulatePlatformPartList( Point* );
			public:
				GameScene( AlienTypes );
				~GameScene();
				ItemList<PlayerBullet*>* getPlayerBullets() const;
				ItemList<AlienBullet*>* getAlienBullets() const;
				ItemList<Alien*>* getAliens() const;
				ItemList<PlatformPart*>* getPlatformParts() const;
				Player* getPlayer() const;
				ImageActor* getBackgroundActor() const;
				BonusShip* getBonusShip() const;
				void PopulateRenderingBuffer( BITMAP* );
		};
	}
}