// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include <fstream>
#include <string>
#include "AllegroSettings.h"
#include "GameSettings.h"
using namespace std;
using namespace AllegroEngine;
using namespace GameEngine;

namespace FileSystem
{
	//	File class : Implements a file
	
	class File
	{
		protected:
			//	Attribute
			const char* fileName;
		public:
			//	Constructors / Destructor
			File();
			File( char* FileName );
			~File();

			//	Accessors
			void SetFileName( const char* FileName );
			char* GetFileName();
			
			//	Methods
			bool Exists();
			static bool Exists( const char* FileName );
			bool Load( AllegroSettings* );
			bool Load( GameSettings* );
			bool Save( AllegroSettings* );
			bool Save( GameSettings* );
	};
}