// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "file.h"

namespace FileSystem
{
	//	Constructors / Destructor
	File::File():
	fileName( "" )
	{
	}

	File::File( char* FileName ):
	fileName( FileName )
	{
	}

	File::~File()
	{
	}

	//	Accessors
	void File::SetFileName( const char* FileName )
	{
		fileName = FileName;
	}
	
	char* File::GetFileName()
	{
		return (char*)fileName;
	}

	//	Methods
	bool File::Exists()
	{
		return Exists( fileName );
	}
	
	bool File::Exists( const char* FileName )
	{
		if ( FileName != "" )
		{
			ifstream infile( FileName );
			if ( infile )
			{
				infile.close();
				return true;
			}
			infile.close();
		}

		return false;
	}

	bool File::Load( AllegroSettings* loadSettings )
	{
		if ( fileName != "" )
		{
			std::ifstream fin(fileName, ios_base::in | ios_base::binary);

			if (!fin.is_open())
				return false;

			fin.read((char*)loadSettings, sizeof(AllegroSettings));
			fin.close();
			return true;
		}
		return false;
	}

	bool File::Load( GameSettings* loadSettings )
	{
		if ( fileName != "" )
		{
			std::ifstream fin(fileName, ios_base::in | ios_base::binary);

			if (!fin.is_open())
				return false;

			fin.read((char*)loadSettings, sizeof(GameSettings));
			fin.close();
			return true;
		}
		return false;
	}

	bool File::Save( AllegroSettings* saveSettings )
	{
		if ( fileName != "" )
		{
			std::ofstream fout(fileName, ios_base::out | ios_base::binary | ios_base::trunc);
			
			if (!fout.is_open())
				return false;

			fout.write((const char*)saveSettings, sizeof(AllegroSettings));
			fout.close();
			
			return true;
		}
		return false;
	}

	bool File::Save( GameSettings* saveSettings )
	{
		if ( fileName != "" )
		{
			std::ofstream fout(fileName, ios_base::out | ios_base::binary | ios_base::trunc);
			
			if (!fout.is_open())
				return false;

			fout.write((const char*)saveSettings, sizeof(GameSettings));
			fout.close();
			
			return true;
		}
		return false;
	}
}