// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "allegro.h"
#include <string>

using namespace std;

#define ALIEN_FILE_NAME "alien.dat"
#define BACKGROUNDS_FILE_NAME "background.dat"
#define BOMBS_FILE_NAME "bomb.dat"
#define BONUS_FILE_NAME "bonus.dat"
#define PLAYER_FILE_NAME "player.dat"
#define SOUND_FILE_NAME "sound.dat"
#define SCREEN_FILE_NAME "screen.dat"
#define PLATFORM_FILE_NAME "platform.dat"
#define OPTIONS_FILE_NAME "options.dat"
#define DATAFILE_LOAD_ERROR "Unable to load datafile "

namespace GameContent
{
	class DataFile
	{
		protected:
			DATAFILE* _dataFile;
			char* _fileName;
			void LoadContents();
			void ClearDataFile();
		public:
			DataFile();
			DataFile( char* );
			~DataFile();
			void setFileName( char* );
			char* getFileName() const;
			BITMAP* getBitmap( int ) const;
			SAMPLE* getSample( int ) const;
			MIDI* getMidi( int ) const;
	};
}