// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "bulletmanager.h"
#include "gamesession.h"
using namespace Application::Sessions;

namespace GameEngine
{
	namespace Managers
	{
		BulletManager::BulletManager():
		_playerFired(false), _playerFiredBulletCount(0)
		{
		}

		void BulletManager::HandleMovement()
		{
			HandleAlienBulletMovement(); 
			HandlePlayerBulletMovement();
		}

		void BulletManager::HandleAlienBulletMovement()
		{
			Player* player = ((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getPlayer();
			list<AlienBullet*>* alienBulletList = ((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getAlienBullets()->getInnerList();
			PlatformManager* platformManager = ((GameSession*)SessionManager::getInstance()->getCurrentSession())->getPlatformManager();

			for ( list<AlienBullet*>::reverse_iterator alienIterator = alienBulletList->rbegin(); alienIterator != alienBulletList->rend(); alienIterator++ )
				{
					(*alienIterator)->Move();
					if ( (*alienIterator)->getLocation()->y > SCREEN_H )
						(*alienIterator)->RemoveFromContainer();
					else
					{
						if ( !player->CheckForCollision( *alienIterator ) )
						{
							if ( platformManager->CheckForCollision( *alienIterator ) )
								(*alienIterator)->RemoveFromContainer();
						}
					}
				}
		}

		void BulletManager::HandlePlayerBulletMovement()
		{
			AlienManager* alienManager = ((GameSession*)SessionManager::getInstance()->getCurrentSession())->getAlienManager();
			BonusShipManager* bonusShipManager = ((GameSession*)SessionManager::getInstance()->getCurrentSession())->getBonusShipManager();
			PlatformManager* platformManager = ((GameSession*)SessionManager::getInstance()->getCurrentSession())->getPlatformManager();
			list<PlayerBullet*>* playerBulletList = ((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getPlayerBullets()->getInnerList();
			
			for ( list<PlayerBullet*>::reverse_iterator playerIterator = playerBulletList->rbegin(); playerIterator != playerBulletList->rend(); playerIterator++ )
				{
					(*playerIterator)->Move();
					if ( (*playerIterator)->getLocation()->y < 0 )
						(*playerIterator)->RemoveFromContainer();
					else
					{
						if ( !alienManager->CheckForCollision( *playerIterator ) )
							if ( !bonusShipManager->CheckForCollision( *playerIterator ) )
							{
								if ( platformManager->CheckForCollision( *playerIterator ) )
									(*playerIterator)->RemoveFromContainer();
							}
					}
				}
		}

		void BulletManager::addPlayerBullet( Point* BulletPosition )
		{
			if ( !_playerFired )
			{
				_playerFired = true;
				((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getPlayerBullets()->Insert( new PlayerBullet( BulletPosition ) );
				_playerFiredBulletCount++;
			}
		}

		void BulletManager::addAlienBullet( Point* BulletPosition )
		{
			((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getAlienBullets()->Insert( new AlienBullet( BulletPosition ) );
		}

		void BulletManager::setPlayerFired( bool PlayerFired )
		{
			_playerFired = PlayerFired;
		}

		unsigned int BulletManager::getPlayerFiredBulletCount() const
		{
			return _playerFiredBulletCount;
		}
	}
}