// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once

namespace AllegroEngine
{	
	enum ColorDepth {NotDefined=0, bit8=8, bit16=16, bit32=32};
	
	class AllegroSettings
	{
		private:
			unsigned int _virtualHeight;
			unsigned int _virtualWidth;
			unsigned int _width;
			unsigned int _height;
			ColorDepth _colorDepth;
			bool _useMouse;
			bool _useKeyboard;
			bool _waitForVsync;
		public:
			AllegroSettings();
			AllegroSettings( unsigned int, unsigned int, ColorDepth, bool, bool );
			AllegroSettings( unsigned int, unsigned int, ColorDepth, bool, bool, unsigned int, unsigned int );
			~AllegroSettings();
			void setVirtualHeight( unsigned int );
			void setVirtualWidth( unsigned int );
			void setHeight( unsigned int );
			void setWidth( unsigned int );
			void setUseMouse( bool );
			void setUseKeyboard( bool );
			void setColorDepth( ColorDepth );
			unsigned int getVirtualHeight() const;
			unsigned int getVirtualWidth() const;
			unsigned int getHeight() const;
			unsigned int getWidth() const;
			ColorDepth getColorDepth() const;
			bool getUseMouse() const;
			bool getUseKeyboard() const;
	};
}