// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "Alien.h"
#include "actormovementmanager.h"
#include "playerbullet.h"
using namespace GameEngine::Actors;

namespace GameEngine
{
	namespace Managers
	{
		class AlienManager : public ActorMovementManager
		{
			private:
				int _leftMostAlien;
				int _rightMostAlien;
				int _delay;
				void HandleDirection();
				bool ShouldAlienShoot();
				bool AlienIsOnTheRightMostSide( Alien* );
				bool AlienIsOnTheLeftMostSide( Alien* );
				float _bulletChanceLevelMultiplier;
				MoveDirection _alienDirection;
			public:
				AlienManager( float, int );
				void HandleMovement();
				bool CheckForCollision( PlayerBullet* );
		};
	}
}