// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "alienbullet.h"
#include "gamesession.h"
using namespace Application::Sessions;

namespace GameEngine
{
	namespace Actors
	{
		AlienBullet::AlienBullet( Point* StartLocation )
		{
			_location = StartLocation;
			_delay = GameSettings::getInstance()->getAlienBulletAnimationDelay();
		}

		BITMAP* AlienBullet::getBitmap() const
		{
			return BulletsDataFile::getInstance()->getAlienBulletFrame( _currentFrame );
		}

		void AlienBullet::Move()
		{
			_location->y += ((GameSession*)SessionManager::getInstance()->getCurrentSession())->getLevel()->getAlienBulletSpeed();
			setCurrentFrame();
		}

		void AlienBullet::setCurrentFrame()
		{
			--_delay;
			if ( _delay == 0 )
			{
				++_currentFrame;
				_currentFrame = ( _currentFrame == 3 ) ? 0 : _currentFrame;
				_delay = GameSettings::getInstance()->getAlienBulletAnimationDelay();
			}
		}
	}
}