// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "aliendatafile.h"
using namespace GameContent;
#include "AnimationFacade.h"
#include "statesfacade.h"

#define ALIENS_PER_LINE 4
#define ALIEN_LINES 3
#define SEPERATION_WIDTH 10
#define SEPERATION_HEIGHT 10

namespace GameEngine
{
    namespace Actors
	{
		class Alien : public Actor, public AnimationFacade, public StatesFacade<ActorStates>
		{
			private:
				AlienTypes _alienType;
				void setCurrentFrame();
				void stateChanged();
			public:
				Alien( AlienTypes );
				void Move( MoveDirection );
				AlienTypes getAlienType() const;
				Point* getBulletStartLocation();
				BITMAP* getBitmap() const;
		};
	}
}