// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include <allegro.h>
#include "listitem.h"
#include "rectangle.h"
using namespace DataStructures;
#include "gamesettings.h"

namespace GameEngine
{
	namespace Actors
	{
		enum MoveDirection { MoveLeft, MoveRight, MoveDown, MoveUp };
		
		class Actor : public ListItem
		{
			protected:
				Point* _location;
				Rectangle* _rectangle;
				void DrawSprite( BITMAP*, BITMAP* );
				void Blit( BITMAP*, BITMAP* );
			public:
				Actor();
				~Actor();
				void setLocation( Point* );
				Point* getLocation() const;
				virtual int getWidth() const;
				virtual int getHeight() const;
				virtual void Move();
				Rectangle* getRectangle();
				virtual void Render( BITMAP* );
				virtual BITMAP* getBitmap() const = 0;
		};
	}
}