
// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)
#pragma once
#include "settingsreader.h"

namespace Xml
{
	Level* SettingsReader::getLevel( char* FileName )
	{
		string buffer = LoadFile( FileName );
				
		Level* level = new Level();
		level->setID( getInt( "<id>", buffer ) );
		level->setAlienType( (AlienTypes)getInt( "<alienrace>", buffer ) );
		level->setBulletChancePerSecond( getInt( "<bulletchancepersecond>", buffer ) );		
		level->setPlayerBulletSpeed( getInt( "<playerbulletspeed>", buffer ) );
		level->setAlienBulletSpeed( getInt( "<alienbulletspeed>", buffer ) );
		level->setAlienSpeed( getInt( "<alienspeed>", buffer ) );
		level->setPlayerSpeed( getInt( "<playerspeed>", buffer ) );
		level->setAlienMoveDelay( getInt( "<alienmovedelay>", buffer ) );
		level->setBonusShipSpeed( getInt( "<bonusshipspeed>", buffer ) );
		level->setPlatformDestructionLevel( getInt( "<platformdestructionlevel>", buffer ) );
		level->setBonusShipRate( getInt( "<bonusshiprate>", buffer ) );
		return level;
	}

	string SettingsReader::LoadFile( char* FileName )
	{
		char buffer[50];
		string result;

		ifstream infile( FileName );
		while ( infile )
		{
			string str = "";
			infile.getline( buffer, 50 );
			result += buffer;
		}

		return result;
	}

	// BE VERY CASE SENSITIVE ABOUT IT
	int SettingsReader::getInt( string name, string buffer )
	{
		int pos = buffer.find( name, 0 );
		
		pos += name.size();
		string result = "";
	
		while( buffer[pos] != '<' )
			result += buffer[pos++];

		return atoi(result.c_str());
	}
}