// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "session.h"
#include "creditsession.h"
#include "renderingengine.h"
using namespace Renderer;
using namespace GameEngine;
using namespace Application::Sessions;

namespace Application
{
	enum SessionStates { NotDefined, Running, Switching, Ending };
	
	class SessionManager
	{
		private:
			Session* _currentSession;
			static SessionManager* _sessionManager;
			Session* _nextSession;
			int _actualCycle;
			void HandleSessionState();
			void Render();
			void HandleMovement();
			void SwitchSessions();
			SessionStates _sessionState;
			void StopCurrentSession();
			void HandleUserInput();
		public:
			SessionManager();
			~SessionManager();
			static SessionManager* getInstance();
			Session* getCurrentSession();
			void setNextSession( Session* );
			void Start();
			void StopTimer();
			void StartTimer();
			void Stop();
			void Pause();
			int getTargetCycle();
			void ResetKeyboard();
			void DrawAnnouncement( BITMAP* );
	};
}