// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "scoreelement.h"

namespace GameEngine
{
	ScoreElement::ScoreElement()
	{
	}
	
	ScoreElement::ScoreElement( string Name, unsigned int Score ):
	_name( Name ), _score( Score )
	{
	}

	bool ScoreElement::operator <( ScoreElement& element )
	{
		return _score < element._score;
	}

	bool ScoreElement::operator >( ScoreElement& element )
	{
		return _score > element._score;
	}

	string ScoreElement::getName() const
	{
		return _name;
	}

	unsigned int ScoreElement::getScore() const
	{
		return _score;
	}
}