// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "actor.h"
#include "screendatafile.h"
using namespace GameContent;
using namespace GameEngine;

#define SCOREBOARD_W 430
#define SCOREBOARD_H 26
#define NEXT_NUMBER 20
#define PIXEL 1
#define NUM_W 25
#define NUM_H 26
#define NUMBERS_LOCATION 6

namespace GameEngine
{
	namespace Actors
	{
		enum ChangeScoreTypes { Nothing=0, AlienHit=100, BonusHit=150, LevelHit=50 };

		class ScoreBoard : public Actor
		{
			private:
				static ScoreBoard* _scoreBoard;
				unsigned int _score;
				BITMAP* _drawBitmap;
				void DrawScore();
			public:
				ScoreBoard();
				~ScoreBoard();
				static ScoreBoard* getInstance();
				BITMAP* getBitmap() const;
				void changeScore( ChangeScoreTypes );
				unsigned int getCurrentScore();
		};
	}
}