// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#include "scene.h"

namespace Application
{
	namespace Scenery
	{
		template <class T>
		void Scene::PopulateRenderingBuffer( BITMAP* Buffer, ItemList<T>* itemList )
		{
			list<T>* innerList = itemList->getInnerList();
			for ( list<T>::const_iterator iterator = innerList->begin(); iterator != innerList->end(); ++iterator )
				(*iterator)->Render( Buffer );
		}
	}
}