// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "gamesettings.h"
#include "scoreboard.h"
#include "actor.h"
#include "ScreenDataFile.h"

using namespace GameContent;

#define PANEL_H 26
#define NEXT_LIVE 30
#define POSITION_X 0
#define POSITION_Y 0
#define PIXEL 1

namespace GameEngine
{
	namespace Actors
	{
		class PlayerPanel : public Actor
		{
			private:
				unsigned int _playerLives;
				ScoreBoard* _scoreBoard;
				BITMAP* _drawBitmap;
			public:
				PlayerPanel();
				~PlayerPanel();
				void DecreasePlayerLives();
				int getPlayerLives() const;
				BITMAP* getBitmap() const;
				ScoreBoard* getScoreBoard() const;
		};
	}
}