// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "platformmanager.h"
#include "gamesession.h"
using namespace Application::Sessions;

namespace GameEngine
{
	namespace Managers
	{
		bool PlatformManager::CheckForCollision( Actor* actor )
		{
			list<PlatformPart*>* platformPartsList = ((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getPlatformParts()->getInnerList();
			for ( list<PlatformPart*>::reverse_iterator iterator = platformPartsList->rbegin(); iterator != platformPartsList->rend(); ++iterator )
			{
				if ( (*iterator)->CheckForCollision( actor ) )
					return true;
			}
			return false;
		}

		void PlatformManager::HandleMovement()
		{
		}
	}
}