// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "aliendatafile.h"
#include "listitem.h"
#include "screendatafile.h"
using namespace GameContent;
using namespace DataStructures;

#define LEVELNUMBERS_LOCATION 18

namespace GameContent
{
	class Level : public ListItem
	{
		private:
			unsigned int _id;
			AlienTypes _alienType;
			float _bulletChanceLevelMultiplier;
			int _playerBulletSpeed;
			int _alienBulletSpeed;
			int _alienSpeed;
			int _playerSpeed;
			int _alienMoveDelay;
			int _bonusShipSpeed;
			int _platformDestructionLevel;
			int _bonusShipRate;
			unsigned short int _bonusShips;
			BITMAP* _bitmap;
			void CreateBitmap();
		public:
			Level();
			~Level();
			AlienTypes getAlienType() const;
			unsigned int getID() const;
			float getBulletChanceLevelMultiplier() const;
			unsigned short int getBonusShips();
			BITMAP* getBitmap();
			void setAlienType( AlienTypes );
			void setID( unsigned int );
			void setBulletChancePerSecond( int );		
			void setPlayerBulletSpeed( int );
			void setAlienBulletSpeed( int );
			void setAlienSpeed( int );
			void setPlayerSpeed( int );
			void setAlienMoveDelay( int );
			void setBonusShipSpeed( int );
			void setPlatformDestructionLevel( int );
			void setBonusShipRate( int );
			int getBulletChancePerSecond() const;	
			int getPlayerBulletSpeed() const;
			int getAlienBulletSpeed() const;
			int getAlienSpeed() const;
			int getPlayerSpeed() const;
			int getAlienMoveDelay() const;
			int getBonusShipSpeed() const;
			int getPlatformDestructionLevel() const;
			int getBonusShipRate() const;
	};
}