// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "level.h"

namespace GameContent
{
	Level::Level():
	_bitmap( NULL ), _bonusShips(5), _bulletChanceLevelMultiplier(0.2)
	{
	}

	Level::~Level()
	{
		destroy_bitmap( _bitmap );
	}

	void Level::setAlienType( AlienTypes AlienType )
	{
		_alienType = AlienType;
	}

	void Level::setID( unsigned int ID )
	{
		_id = ID;
	}

	unsigned int Level::getID() const
	{
		return _id;
	}

	AlienTypes Level::getAlienType() const
	{
		return _alienType;
	}

	float Level::getBulletChanceLevelMultiplier() const
	{
		return _bulletChanceLevelMultiplier;
	}

	unsigned short int Level::getBonusShips()
	{
		return _bonusShips;
	}

	void Level::CreateBitmap()
	{
		BITMAP* bitmap = ScreenDataFile::getInstance()->getScreen( LevelScreen );
		BITMAP* number = ScreenDataFile::getInstance()->getScreen( (ScreenTypes)(_id+LEVELNUMBERS_LOCATION) );
		_bitmap = create_bitmap( bitmap->w, bitmap->h );
		draw_sprite( _bitmap, bitmap, 0, 0 );
		draw_sprite( _bitmap, number, 280, 95 );
	}

	BITMAP* Level::getBitmap()
	{
		if ( _bitmap == NULL )
			CreateBitmap();

		return _bitmap;
	}

	void Level::setBulletChancePerSecond( int b )
	{
		//_
	}

	void Level::setPlayerBulletSpeed( int p )
	{
		_playerBulletSpeed = p;
	}

	void Level::setAlienBulletSpeed( int a )
	{
		_alienBulletSpeed = a;
	}

	void Level::setAlienSpeed( int as )
	{
		_alienSpeed = as;
	}

	void Level::setPlayerSpeed( int p )
	{
		_playerSpeed = p;
	}

	void Level::setAlienMoveDelay( int d )
	{
		_alienMoveDelay = d;
	}

	void Level::setBonusShipSpeed( int a )
	{
		_bonusShipSpeed = a;
	}

	void Level::setPlatformDestructionLevel( int k )
	{
		_platformDestructionLevel = k;
	}

	void Level::setBonusShipRate( int a )
	{
		_bonusShipRate = a;
	}
	
	int Level::getBulletChancePerSecond() const
	{
		return -1;
	}

	int Level::getPlayerBulletSpeed() const
	{
		return _playerBulletSpeed;
	}

	int Level::getAlienBulletSpeed() const
	{
		return _alienBulletSpeed;
	}

	int Level::getAlienSpeed() const
	{
		return _alienSpeed;
	}

	int Level::getPlayerSpeed() const
	{
		return _playerSpeed;
	}

	int Level::getAlienMoveDelay() const
	{
		return _alienMoveDelay;
	}

	int Level::getBonusShipSpeed() const
	{
		return _bonusShipSpeed;
	}

	int Level::getPlatformDestructionLevel() const
	{
		return _platformDestructionLevel;
	}

	int Level::getBonusShipRate() const
	{
		return _bonusShipRate;
	}
}