// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#define GAME_CONFIGURATION_FILE "GameSettings.cfg"

namespace GameEngine
{
	class GameSettings
	{
		private:
			static GameSettings* _gameSettings;
			int _alienAnimationDelay;
			int _bonusShipAnimationDelay;
			int _playerLives;
			float _bulletChancePerSecond;
			int _alienBulletAnimationDelay;
			int _playerExplosionAnimationDelay;
			int _alienExplosionDelay;
			int _bonusPoints;
			int _alienPoints;
			bool _singleFire;
			int _bonusShipRate;
		public:
			GameSettings();
			~GameSettings();
			static GameSettings* getInstance();
			int getAlienAnimationDelay() const;
			int getBonusShipAnimationDelay() const;
			int getPlayerLives() const;
			float getBulletChancePerSecond() const;
			int getAlienBulletAnimationDelay() const;
			int getPlayerExplosionAnimationDelay() const;
			int getAlienExplosionDelay() const;
			int getBonusPoints() const;
			int getAlienPoints() const;
			bool getSingleFire() const;
			void setPlayerLives( int );
			void setBulletChancePerSecond( float );
			void setBonusPoints( int );
			void setAlienPoints( int );
			void setSingleFire( bool );
	};
}