// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "session.h"
#include "alienmanager.h"
#include "bulletmanager.h"
#include "bonusshipmanager.h"
#include "platformmanager.h"
#include "inputsession.h"
#include "sounddatafile.h"
#include "highscoremanager.h"
#include "screendatafile.h"
#include "gamescene.h"
#include "mainmenusession.h"
#include "playerpanel.h"
#include "levelloader.h"
#include "scoreboard.h"
#include "sounddatafile.h"
using namespace GameEngine;
using namespace Application::Scenery;
using namespace GameContent;
using namespace GameEngine::Managers;

#define SURE_X 100
#define SURE_Y 100
#define OVER_X 500
#define OVER_Y 360
#define PRESSANY_X 100
#define PRESSANY_Y 100

namespace Application
{
	namespace Sessions
	{
		class GameSession : public Session
		{
			private:
				AlienManager* _alienManager;
				BulletManager* _bulletManager;
				BonusShipManager* _bonusShipManager;
				PlatformManager* _platformManager;
				GameScene* _scene;
				PlayerPanel* _playerPanel;
				Level* _level;
				void Destruct();
				void setLevel( Levels );
				void InitLevel();
				void Pause();
				void EndLevel();
			public:
				GameSession( Levels );
				~GameSession();
				void HandleUserInput();
				void HandleMovement();
				BulletManager* getBulletManager() const;
				AlienManager* getAlienManager() const;
				BonusShipManager* getBonusShipManager() const;
				PlatformManager* getPlatformManager() const;
				Scene* getScene() const;
				PlayerPanel* getPlayerPanel() const;
				void PopulateRenderingBuffer();
				void setNextLevel();
				Level* getLevel() const;
		};
	}
}