// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "actormovementmanager.h"
#include "actor.h"
#include "playerbullet.h"
#include "alienbullet.h"
using namespace GameEngine::Actors;

namespace GameEngine
{
	namespace Managers
	{
		class BulletManager : public ActorMovementManager
		{
			private:
				bool _playerFired;
				unsigned int _playerFiredBulletCount;
				void HandleAlienBulletMovement();
				void HandlePlayerBulletMovement();
			public:
				BulletManager();
				void HandleMovement();
				void addAlienBullet( Point* );
				void addPlayerBullet( Point* );
				void setPlayerFired( bool );
				unsigned int getPlayerFiredBulletCount() const;
		};
	}
}