// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "bonusship.h"
#include "gamesession.h"
using namespace Application::Sessions;

namespace GameEngine
{
	namespace Actors
	{
		BITMAP* BonusShip::getBitmap() const
		{
			if ( _bonusType != NotDefinedBonus )
			{
				switch( _actorState )
				{
					case Alive:
						return BonusDataFile::getInstance()->getBonusFrame( _bonusType, _currentFrame );
					case Exploding:
						return AlienDataFile::getInstance()->getExplosionFrame(0);
				}
			}

			return NULL;
		}

		void BonusShip::Move()
		{
			if ( _bonusType != NotDefinedBonus  )
			{
				if ( _actorState == Alive )
				{
					int speed = ((GameSession*)SessionManager::getInstance()->getCurrentSession())->getLevel()->getBonusShipSpeed();
					switch( _bonusType )
					{
						case FancySaucer:
						{
							_location->x -= speed;
							if ( _location->x == -getWidth() )
								_bonusType = NotDefinedBonus;

							break;
						}
						case HatSaucer:
						{
							_location->x -= speed;

							if ( _location->x == -getWidth() )
								_bonusType = NotDefinedBonus;

							break;
						}
						case PlainSaucer:
						{
							_location->x += speed;

							if ( _location->x == SCREEN_W + getWidth() )
								_bonusType = NotDefinedBonus;

							break;
						}
						case Planet:
						{
							_location->x += speed;

							if ( _location->x == SCREEN_W + getWidth() )
								_bonusType = NotDefinedBonus;

							break;
						}
					}
				}

				setCurrentFrame();
			}
		}

		void BonusShip::stateChanged()
		{
			switch ( _actorState )
			{
				case Alive:
				{
					_delay = GameSettings::getInstance()->getBonusShipAnimationDelay();
					break;
				}
				case Exploding:
				{
					_delay = GameSettings::getInstance()->getAlienExplosionDelay();
					break;
				}
			}
			
			_currentFrame = 0;
		}

		BonusShip::BonusShip()
		{
			setActorState( Alive );
			_delay = GameSettings::getInstance()->getBonusShipAnimationDelay();
			setBonusType( NotDefinedBonus );
		}

		void BonusShip::setCurrentFrame()
		{
			--_delay;
			switch( _actorState )
			{
				case Alive:
				{
					if ( _delay == 0 )
					{
						_currentFrame = ( ++_currentFrame == 2 ) ? 0 : _currentFrame;
						_delay = ((GameSession*)SessionManager::getInstance()->getCurrentSession())->getLevel()->getBonusShipSpeed();
					}
					break;
				}
				case Exploding:
				{
					if ( _delay == 0 )
					{
						_bonusType = NotDefinedBonus;
						setActorState( Alive );
						((GameSession*)SessionManager::getInstance()->getCurrentSession())->getPlayerPanel()->getScoreBoard()->changeScore( BonusHit );
					}

					break;
				}
			}
		}

		BonusTypes BonusShip::getBonusType() const
		{
			return _bonusType;
		}

		void BonusShip::setBonusType( BonusTypes BonusType )
		{
			int x = 0;
			_bonusType = BonusType;
			switch( _bonusType )
			{
				case FancySaucer:
				{
					x = SCREEN_W + getWidth();
					break;
				}
				case HatSaucer:
				{
					x = SCREEN_W + getWidth();
					break;
				}
				case PlainSaucer:
				{
					x = (-1)*getWidth();
					break;
				}
				case Planet:
				{
					x = (-1)*getWidth();
					break;
				}
				case NotDefinedBonus:
				{
					_location = NULL;
					break;
				}
			}
			
			if ( _bonusType != NotDefinedBonus )
				_location = new Point( x, BONUS_SHIP_VERTICAL_SPACE );
		}
	}
}