// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "allegrosettings.h"

namespace AllegroEngine
{
	AllegroSettings::AllegroSettings():
	_height(0),_width(0),_virtualHeight(0),_virtualWidth(0),_useMouse(false),_useKeyboard(false), _colorDepth(NotDefined)
	{
	}

	AllegroSettings::AllegroSettings( unsigned int Width, unsigned int Height, ColorDepth ColorDepth, bool UseKeyboard, bool UseMouse ):
	_height(Height),_width(Width),_virtualHeight(0),_virtualWidth(0),_useMouse(UseMouse),_colorDepth(ColorDepth),_useKeyboard(UseKeyboard)
	{
	}

	AllegroSettings::AllegroSettings( unsigned int Width, unsigned int Height, ColorDepth ColorDepth, bool UseKeyboard, bool UseMouse, unsigned int VirtualWidth, unsigned int VirtualHeight ):
	_height(Height),_width(Width),_virtualHeight(VirtualHeight),_virtualWidth(VirtualWidth),_useMouse(UseMouse),_useKeyboard(UseKeyboard), _colorDepth(ColorDepth)
	{
	}

	AllegroSettings::~AllegroSettings()
	{
	}

	void AllegroSettings::setColorDepth( ColorDepth ColorDepth )
	{
		_colorDepth = ColorDepth;
	}

	void AllegroSettings::setHeight( unsigned int Height )
	{
		_height = Height;	
	}

	void AllegroSettings::setWidth( unsigned int Width )
	{
		_width = Width;
	}

	void AllegroSettings::setVirtualHeight( unsigned int VirtualHeight )
	{
		_virtualHeight = VirtualHeight;
	}

	void AllegroSettings::setVirtualWidth( unsigned int VirtualWidth )
	{
		_virtualWidth = VirtualWidth;
	}

	void AllegroSettings::setUseKeyboard( bool UseKeyboard )
	{
		_useKeyboard = UseKeyboard;
	}

	void AllegroSettings::setUseMouse( bool UseMouse )
	{
		_useMouse = UseMouse;
	}

	ColorDepth AllegroSettings::getColorDepth() const
	{
		return _colorDepth;
	}

	unsigned int AllegroSettings::getHeight() const
	{
		return _height;
	}

	unsigned int AllegroSettings::getWidth() const
	{
		return _width;
	}

	bool AllegroSettings::getUseKeyboard() const
	{
		return _useKeyboard;
	}

	bool AllegroSettings::getUseMouse() const
	{
		return _useMouse;
	}

	unsigned int AllegroSettings::getVirtualHeight() const
	{
		return _virtualHeight;
	}

	unsigned int AllegroSettings::getVirtualWidth() const
	{
		return _virtualWidth;
	}
}