// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "AlienManager.h"
#include "gamesession.h"
#include "statesfacade.cpp"
using namespace Application::Sessions;

namespace GameEngine
{
	namespace Managers
	{
		AlienManager::AlienManager( float BulletChanceLevelMultiplier, int d ):
		_alienDirection( MoveRight ), _bulletChanceLevelMultiplier( BulletChanceLevelMultiplier )
		{
			_delay = d; //((GameSession*)SessionManager::getInstance()->getCurrentSession())->getLevel()->getAlienMoveDelay();
		}

		void AlienManager::HandleMovement()
		{
			_leftMostAlien = _rightMostAlien = -1;
			PlatformManager* platformManager = ((GameSession*)SessionManager::getInstance()->getCurrentSession())->getPlatformManager();
			Player* player = ((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getPlayer();
			list<Alien*>* aliens = ((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getAliens()->getInnerList();
			int i=0;
			for ( list<Alien*>::reverse_iterator iterator = aliens->rbegin(); iterator != aliens->rend(); ++iterator, i++ )
				{
					if ( (*iterator)->getActorState() == Alive )
					{
						if ( _leftMostAlien == -1 ) _leftMostAlien = i;
						if ( i > _rightMostAlien ) 	_rightMostAlien = i % ALIENS_PER_LINE;
						(*iterator)->Move( _alienDirection );

						if ( ShouldAlienShoot() )
							((GameSession*)SessionManager::getInstance()->getCurrentSession())->getBulletManager()->addAlienBullet( (*iterator)->getBulletStartLocation() );
							
						if ( !platformManager->CheckForCollision( *iterator ) )
							if ( (*iterator)->getRectangle()->IntersectsWith( player->getRectangle() ) )
							{
								if ( player->getActorState() != PlayerExploding )
									player->setActorState( PlayerExploding );
							}
					}
					else
					{
						if ( _leftMostAlien == -1 ) _leftMostAlien = i;
						if ( i > _rightMostAlien ) 	_rightMostAlien = i % ALIENS_PER_LINE;

						(*iterator)->Move( _alienDirection );
					}
				}

			if (_leftMostAlien == -1 && _rightMostAlien == -1) 
				((GameSession*)SessionManager::getInstance()->getCurrentSession())->setNextLevel();
			else
				HandleDirection();
		}

		bool AlienManager::ShouldAlienShoot()
		{
			float cutoff = 10000 * GameSettings::getInstance()->getBulletChancePerSecond() * _bulletChanceLevelMultiplier * ((float)SessionManager::getInstance()->getTargetCycle()/1000);
			return ( Random::GetNumber(0,10000) < cutoff );
		}

		bool AlienManager::CheckForCollision(PlayerBullet* Bullet)
        {
			list<Alien*>* aliens = ((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getAliens()->getInnerList();
			for ( list<Alien*>::reverse_iterator iterator = aliens->rbegin(); iterator != aliens->rend(); ++iterator )
			{
				if ( (*iterator)->getActorState() == Alive )
				{
					Rectangle* a = (*iterator)->getRectangle();
					Rectangle* b= Bullet->getRectangle();
					if ( (*iterator)->getRectangle()->IntersectsWith( Bullet->getRectangle() ) )
					{
						(*iterator)->setActorState( Exploding );
						Bullet->RemoveFromContainer();
						return true;
					}
				}
			}

			return false;
        }

		bool AlienManager::AlienIsOnTheRightMostSide( Alien* Alien )
		{
			return ( Alien != NULL && Alien->getLocation()->x + Alien->getWidth() >= SCREEN_W - 10 );
		}

		bool AlienManager::AlienIsOnTheLeftMostSide( Alien* Alien )
		{
			return ( Alien != NULL && Alien->getLocation()->x <= 10 );
		}

		void AlienManager::HandleDirection()
		{
			if ( _alienDirection == MoveDown )
			{
				if ( _delay == 0 )
				{
					_delay = ((GameSession*)SessionManager::getInstance()->getCurrentSession())->getLevel()->getAlienMoveDelay();
					for ( int i=0; i < ALIEN_LINES; i++ )
					{
						if ( AlienIsOnTheRightMostSide( ((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getAliens()->operator[](_rightMostAlien+i*ALIENS_PER_LINE) ) )
						{
							_alienDirection = MoveLeft;
							break;
						}

						if ( AlienIsOnTheLeftMostSide( ((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getAliens()->operator[](_leftMostAlien+i*ALIENS_PER_LINE) ) )
						{
							_alienDirection = MoveRight;
							break;
						}
					}
				}
				else
					_delay--;
			}
			
			if ( _alienDirection == MoveLeft )
			{
				for ( int i=0; i < ALIEN_LINES; i++ )
				{
					if ( AlienIsOnTheLeftMostSide( (Alien*)((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getAliens()->operator[](_leftMostAlien+i*ALIENS_PER_LINE) ) )
					{
						_alienDirection = MoveDown;
						break;
					}
				}
			}
			
			if ( _alienDirection == MoveRight )
			{
				for ( int i=0; i < ALIEN_LINES; i++ )
				{
					if ( AlienIsOnTheRightMostSide( (Alien*)((GameScene*)SessionManager::getInstance()->getCurrentSession()->getScene())->getAliens()->operator[](_rightMostAlien+i*ALIENS_PER_LINE)))
					{
						_alienDirection = MoveDown;
						break;
					}
				}
			}
		}
	}
}