// Space Invaders Game
// written by:
// Costas Vandikas (vandikas@csd.uoc.gr)
// Stavros Michael (michael@csd.uoc.gr)

#pragma once
#include "AlienDataFile.h"

namespace GameContent
{
	AlienDataFile* AlienDataFile::_alienDataFile = NULL;
	
	AlienDataFile::AlienDataFile()
	{
		setFileName( ALIEN_FILE_NAME );
	}

	BITMAP* AlienDataFile::getExplosionFrame( int Frame ) const
	{
		return getBitmap( Frame + 12 );
	}

	BITMAP* AlienDataFile::getAlienFrame( AlienTypes alienType, int Frame ) const
	{
		switch( alienType )
		{
			case AlienA:
				return getBitmap( Frame );
			case AlienB:
				return getBitmap( Frame + 2);
			case AlienC:
				return getBitmap( Frame + 4 );
			case AlienD:
				return getBitmap( Frame + 6 );
			case AlienE:
				return getBitmap( Frame + 8 );
			case AlienF:
				return getBitmap( Frame + 10 );
		}

		return NULL;
	}

	AlienDataFile* AlienDataFile::getInstance()
	{
		return ( _alienDataFile == NULL ) ? _alienDataFile = new AlienDataFile() : _alienDataFile;
	}
}