#ifndef _WAVE_H_
#define _WAVE_H_

struct wave_element
{
    char const *name;
    int min_choppers;           // how many choppers in this wave
    int max_choppers;
    int min_troopers;           // troopers per chopper
    int max_troopers;
    int min_interval;           // time interval between choppers
    int max_interval;
    int trooper_bonus;          // bonus score for not letting troopers land
    int total_bonus;            // bonus score for killing everything
};

class Wave
{
public:
    enum wave_states
    {
	RUNNING = 0,
	INITIALIZING
    };
    
    Wave();                     // construct the wave generator
    ~Wave();                    // destructor (empty)

    void init(int level=0);
    void update();                       // update (do lots of stuff)
    void generate_chopper();             // make a chopper
    void message_start(int level);       // wave starting
    void message_finish(int level);      // wave completed
    bool choppers_dead();                // count live choppers
    
private:
    int level;
    int max_level;
    int chopper_timer;
    int choppers;
    int wave_pause;
    int state;
};

#endif
