#include "paratrooper.h"
#include <string.h>
#include <math.h>

void vector_set(float *v, float val1, float val2, float val3)
{
    v[0] = val1;
    v[1] = val2;
    v[2] = val3;
}

void glTranslatefv(float *t)
{
    glTranslatef(t[0], t[1], t[2]);
}

void glScalefv(float *t)
{
    glScalef(t[0], t[1], t[2]);
}

void vector_add(float *v1, float *v2)
{
    v1[0] += v2[0];
    v1[1] += v2[1];
    v1[2] += v2[2];
}

void vector_add(float *v1, float *v2, float *v)
{
    v[0] = v1[0] + v2[0];
    v[1] = v1[1] + v2[1];
    v[2] = v1[2] + v2[2];
}

void vector_subtract(float *v1, float *v2)
{
    v1[0] -= v2[0];
    v1[1] -= v2[1];
    v1[2] -= v2[2];
}

void vector_subtract(float *v1, float *v2, float *v)
{
    v[0] = v1[0] - v2[0];
    v[1] = v1[1] - v2[1];
    v[2] = v1[2] - v2[2];
}

void vector_multiply(float *v, float c)
{
    v[0] *= c;
    v[1] *= c;
    v[2] *= c;
}

void vector_assign(float *v1, float *v2)
{
    memcpy(v1, v2, 3 * sizeof(float));
}

float vector_length_xy(float *v)
{
    return sqrt(v[0]*v[0] + v[1]*v[1]);
}

float vector_length(float *v)
{
    return sqrt(v[0]*v[0] + v[1]*v[1] + v[2]*v[2]);
}

void vector_normalize(float *v)
{
    float d = vector_length(v);

    if (d > 0.0)
    {
	vector_multiply(v, 1 / d);
    }
}

// normalize only x and y, for use on cylinders
// divide the z coordinates by 2 instead of normalizing
void vector_normalize_xy(float *v)
{
    float d = vector_length_xy(v);

    if (d > 0.0)
    {
	v[0] /= d;
	v[1] /= d;
    }

    v[2] *= 0.5;
}

// angle in RADIANS!!!!!
// now that I remember how to do this properly, stop using atan2.
// A vector a points from (0,0) to (x,y)
// rotate it by alpha degrees (positive -> ccw)
// a' = (x', y')
// x' = x cos(alpha) - y sin(alpha)
// y' = x sin(alpha) + y cos(alpha)
//
// in case I forget again: draw a with x and y components.
// draw a second coordinate system rotated by -alpha (!!).
// decompose x and y in components orthogonal to the new coordinate
// system and write down the separate contributions.

void vector_rotate_xy(float *v, float alpha)
{
    // only rotate in x y plane. leave z coordinate intact
    float
	cosa = cos(alpha),
	sina = sin(alpha),
	x = v[0],
	y = v[1];

    v[0] = x * cosa - y * sina;
    v[1] = x * sina + y * cosa;
}
