#include "paratrooper.h"
#include "vector.h"
#include <stdio.h>

void draw_triangle(float *v1, float *v2, float *v3)
{
    glBegin(GL_TRIANGLES);

    glVertex3fv(v1);
    glVertex3fv(v2);
    glVertex3fv(v3);
    glVertex3fv(v1);
    
    glEnd();
}

// divide a triangle and normalize on a sphere centered on the origin
void divide_triangle_sphere(float *v1, float *v2, float *v3, int level)
{
    float v4[3], v5[3], v6[3];
    
    // level 0 reached? draw triangle
    if (!level)
    {
	draw_triangle(v1, v2, v3);
	return;
    }

    // subdivide
    vector_add(v1, v2, v4);
    vector_add(v2, v3, v5);
    vector_add(v3, v1, v6);

    // normalize: this only works on a sphere
    vector_normalize(v4);
    vector_normalize(v5);
    vector_normalize(v6);

    // recursively try that again
    divide_triangle_sphere(v1, v4, v6, level - 1);
    divide_triangle_sphere(v4, v2, v5, level - 1);
    divide_triangle_sphere(v5, v3, v6, level - 1);
    divide_triangle_sphere(v4, v5, v6, level - 1);
}

// divide a triangle, normalizing on a cylinder around the z axis
void divide_triangle_cylinder(float *v1, float *v2, float *v3, int level)
{
    float v4[3], v5[3], v6[3];
    
    // level 0 reached? draw triangle
    if (!level)
    {
	draw_triangle(v1, v2, v3);
	return;
    }

    // subdivide
    vector_add(v1, v2, v4);
    vector_add(v2, v3, v5);
    vector_add(v3, v1, v6);

//    printf("sum vectors: [%f, %f, %f] [%f, %f, %f] [%f, %f, %f]\n",
//	   v4[0],v4[1],v4[2],v5[0],v5[1],v5[2],v6[0],v6[1],v6[2]);

    // normalize on a cylinder: only do x and y, leave z intact
    vector_normalize_xy(v4);
    vector_normalize_xy(v5);
    vector_normalize_xy(v6);

//    printf("normalized vectors: [%f, %f, %f] [%f, %f, %f] [%f, %f, %f]\n",
//	   v4[0],v4[1],v4[2],v5[0],v5[1],v5[2],v6[0],v6[1],v6[2]);
    
    
//    vector_multiply(v4, 0.5);
//    vector_multiply(v5, 0.5);
//    vector_multiply(v6, 0.5);
    
    // recursively try that again
    divide_triangle_cylinder(v1, v4, v6, level - 1);
    divide_triangle_cylinder(v4, v2, v5, level - 1);
    divide_triangle_cylinder(v5, v3, v6, level - 1);
    divide_triangle_cylinder(v4, v5, v6, level - 1);
}
