#include <math.h>
#include "tree.h"
#include "paratrooper.h"
#include "globals.h"
#include "vector.h"
#include "random.h"

Tree::Tree()
{
    // init position
    float r, alpha;

    r = random_range(100, MAX_DISTANCE / 4);
    alpha = random_range(0, 2 * M_PI);

    pos[0] = r * cos(alpha);
    pos[1] = r * sin(alpha);
    pos[2] = 0.0;
    
    next = 0;
}

void Tree::draw()
{
    glPushMatrix();
    glTranslatefv(pos);
    
    // tree stump
    glColor3fv(stem);
    glBegin(GL_QUADS);
    glVertex3f(-0.3, 0, 0);
    glVertex3f(0.3, 0, 0);
    glVertex3f(0.3, 0, 2);
    glVertex3f(-0.3, 0, 2);

    glVertex3f(0, -0.3, 0);
    glVertex3f(0, 0.3, 0);
    glVertex3f(0, 0.3, 2);
    glVertex3f(0, -0.3, 2);
    glEnd();

    glColor3fv(leaf);
    glBegin(GL_TRIANGLES);
    glVertex3f(-3, 0, 2);
    glVertex3f(3, 0, 2);
    glVertex3f(0, 0, 10);

    glVertex3f(0, -3, 2);
    glVertex3f(0, 3, 2);
    glVertex3f(0, 0, 10);
    glEnd();

    glPopMatrix();
}
