#include "paratrooper.h"
#include "globals.h"
#include <stdio.h>
#include "message.h"
#include "vector.h"

void draw_score()
{
    static int lastscore = -1;

    glEnable(GL_TEXTURE_2D);
    glPushMatrix();
    
    // scale to fit. height is 1.0
    glTranslatef(0.4, 0.6, -2.1);
    glScalef(0.05, 0.05, 1.0);
    
    allegro_gl_printf(gl_avantgarde, 0, 0, 0,
		      makecol(150, 0, 0), "Score: %d", score);
    
    glPopMatrix();
    glDisable(GL_TEXTURE_2D);
    
    lastscore = score;
}

/*
void draw_game_over()
{
    glEnable(GL_TEXTURE_2D);
    glPushMatrix();

    // scale to fit. height is 1.0
    glTranslatef(-0.7, 0.2, -2.1);
    glScalef(0.25, 0.25, 1.0);
    
    allegro_gl_printf(gl_avantgarde, 0, 0, 0,
		      makecol(150, 0, 0), "GAME OVER!!!");

    glPopMatrix();
    glDisable(GL_TEXTURE_2D);
}
*/

void draw_game_over()
{
    Message *go = new Message("GAME OVER!!!");
    vector_set(go->scale, 0.25, 0.25, 1.0);
    go->color = makecol(150, 0, 0);
    go->leftright();
    go->next = messages;
    messages = go;
}

void draw_fps()
{
    glEnable(GL_TEXTURE_2D);
    glPushMatrix();

    // scale to fit. height is 1.0
    glTranslatef(-0.7, -0.5, -2.1);
    glScalef(0.03, 0.03, 1.0);
    
    allegro_gl_printf(gl_avantgarde, 0, 0, 0,
		      makecol(150, 0, 0), "fps: %d", fps);

    glPopMatrix();
    glDisable(GL_TEXTURE_2D);
}


void my_circle(BITMAP *bmp, int x, int y, int r)
{
    circlefill(bmp, x, y, r, makecol_depth(24, 50, 150, 0));
}

void make_crosshair()
{
    // make transparent
    clear_to_color(crosshair_bmp, makecol_depth(24, 255, 0, 255));

    // draw circle
    circlefill(crosshair_bmp, 63, 63, 60, makecol_depth(24, 50, 150, 0));
    // fill the inner circle with transparent
    circlefill(crosshair_bmp, 63, 63, 55, makecol_depth(24, 255, 0, 255));
    // vertical line
    rectfill(crosshair_bmp, 62, 5, 65, 123, makecol_depth(24, 50, 150, 0));
    // diagonal lines
    do_line(crosshair_bmp, 63, 63, 24, 104, 2, my_circle);
    do_line(crosshair_bmp, 63, 63, 104, 104, 2, my_circle);
    
    // create the texture
    crosshair_tex = allegro_gl_make_masked_texture(crosshair_bmp);
}

void draw_crosshair()
{
    // draw the quad
    // this happens before camera setting, so near clipping plane
    // is the display.
    // it runs from -0.8,-0.6 to 0.8,0.6 at z = 2
    glEnable(GL_TEXTURE_2D);
    // bind the texture
    glBindTexture(GL_TEXTURE_2D, crosshair_tex);

    glBegin(GL_QUADS);
    glTexCoord2f(0, 0);    glVertex3f(-0.03, -0.04, -2.1);
    glTexCoord2f(1, 0);    glVertex3f(0.03, -0.04, -2.1);
    glTexCoord2f(1, 1);    glVertex3f(0.03, 0.02, -2.1);
    glTexCoord2f(0, 1);    glVertex3f(-0.03, 0.02, -2.1);
    glEnd();
    glDisable(GL_TEXTURE_2D);

}

