#include "paratrooper.h"
#include "globals.h"
#include "vector.h"

void draw_radar_point(float *pos, float size)
{
    // scale the position vector to fit on a radius 1 circle
    float radar_pos[3];
    float length;
    
    vector_assign(radar_pos, pos);
    radar_pos[2] = 0;
    vector_normalize_xy(radar_pos);               // normalize to 1
    length = vector_length(pos) / MAX_DISTANCE;   // between 0 and 1
    vector_multiply(radar_pos, sqrt(length));      // blow up the center a bit

    // save current matrix
    glPushMatrix();

    // move to the radar point
    glTranslatefv(radar_pos);
    glScalef(size, size, 1.0);

    // draw a square
    glBegin(GL_QUADS);
    glVertex2f(-1, -1);
    glVertex2f(1, -1);
    glVertex2f(1, 1);
    glVertex2f(-1, 1);
    glEnd();

    // restore
    glPopMatrix();
}

void draw_radar_troopers()
{
    Trooper *tr = troopers;

    while (tr)
    {
	if (tr->state == Trooper::WALK || tr->state == Trooper::STAND)
	    glColor4fv(orange_trans);
	else
	    glColor4fv(blue_trans);

	draw_radar_point(tr->pos, 0.03);
	tr = tr->next;
    }
}

void draw_radar_choppers()
{
    Chopper *ch = choppers;

    glColor4fv(chopper_trans);

    while (ch)
    {
	if (ch->state == Chopper::FLYING || ch->state == Chopper::DROPPING)
	{
	    draw_radar_point(ch->pos, 0.03);
	}
	ch = ch->next;
    }
}

void draw_radar_bullets()
{
    Bullet *b = bullets;

    glColor4fv(red_trans);

    while (b)
    {
	if (b->state != Bullet::DEAD)
	{
	    draw_radar_point(b->pos, 0.01);
	}

	b = b->next;
    }
}


// draw the radar screen use green dots for choppers (dark so they're
// visible) and blue for paratroopers. Put the whole thing on a circle
// with a transparant light green sheen, like a real radar screen.
// make the distance logarithmic so at close distances you can still
// see something.
void draw_radar()
{
    // we're drawing layers on the near clipping plane,
    // turn off depth bufferng
    // viewport is (-0.8, -0.6, -2.0) to (0.8. 0.6, -2.0)
    
    glDisable(GL_DEPTH_TEST);

    // move to the centre of the circle
    // scale so a circle looks like a circle
    glPushMatrix();

    glTranslatef(-0.6, 0.45, -2.1);
    glScalef(0.15, 0.15, 1.0);

    // draw the straight forward line
    glColor4f(0.2, 0.6, 0.2, 0.5);
    glBegin(GL_LINES);
    glVertex2f(0,-0.1);
    glVertex2f(0,1);
    glVertex2f(-0.1,0);
    glVertex2f(0.1,0);
    glEnd();

    // now rotate with the gun so top is forward
    glRotatef(gun->phi, 0, 0, 1);
    
    // now start rotating to draw the circle
    glPushMatrix();
    
    // draw transparent green circle
    for (float angle = 0; angle < 360; angle += 10)
    {
	// set green color, very transparent
	glColor4f(0.2, 0.6, 0.2, 0.2);

	// draw a 10 degree triangle
	glBegin(GL_TRIANGLES);
	glVertex2f(0, 0);
	glVertex2f(1, 0);
	glVertex2f(0.9848, 0.1736);
	glEnd();
	
	// rotate
	glRotatef(10, 0, 0, 1);
    }

    
    glPopMatrix();

    // still at the center but no longer rotated
    
    // draw choppers and troopers
    draw_radar_troopers();
    draw_radar_choppers();
    draw_radar_bullets();
    
    glPopMatrix();

    glEnable(GL_DEPTH_TEST);
}
