#ifndef _MESSAGE_H_
#define _MESSAGE_H_

#include <string>

// message class: print strings across the screen
// enable 'moving messages': fly in from the left, fly out on the right
// and stuff like that. Also enable static messages (score etc)

class Message
{
public:
    enum message_states
    {
	DEAD = 0,
	STATIC,
	APPEAR,
	PRESENT,
	DISAPPEAR,
	MAX_APPEAR_FRAME = 100,
	MAX_PRESENT_FRAME = 300,
	MAX_DISAPPEAR_FRAME = 100
    };

    Message();
    Message(char const *new_str);

    char const *get_str() const;
    void set_str(char const *new_str);
    
    void draw();
    void update();

    void leftright();
    void rightleft();
    void updown();
    void downup();
    
    float pos[3];
    float v[3];
    float scale[3];
    string str;
    Message *next;
    FONT *msg_font;
    FONT *al_font;
    int frame;
    int color;
    int state;
};


#endif
